package playercore

type MasterManifestReady struct {
	Backend                     string  `json:"backend"`
	ChannelID                   string  `json:"channel_id"`
	CoreVersion                 string  `json:"core_version"`
	DeviceID                    string  `json:"device_id"`
	Live                        bool    `json:"live"`
	LowLatency                  bool    `json:"low_latency"`
	Muted                       bool    `json:"muted"`
	Platform                    string  `json:"platform"`
	PlaySessionID               string  `json:"play_session_id"`
	Player                      string  `json:"player"`
	Quality                     string  `json:"quality"`
	TimeToMasterPlaylistReady   int     `json:"time_to_master_playlist_ready"`
	TimeToMasterPlaylistRequest int     `json:"time_to_master_playlist_request"`
	URL                         string  `json:"url"`
	VideoBufferSize             float64 `json:"video_buffer_size"`
	Volume                      int     `json:"volume"`
}

type VideoPlay struct {
	Backend                     string  `json:"backend"`
	BroadcastID                 string  `json:"broadcast_id"`
	ChannelID                   string  `json:"channel_id"`
	Cluster                     string  `json:"cluster"`
	CoreVersion                 string  `json:"core_version"`
	CurrentBitrate              int     `json:"current_bitrate"`
	DeviceID                    string  `json:"device_id"`
	Live                        bool    `json:"live"`
	LowLatency                  bool    `json:"low_latency"`
	ManifestCluster             string  `json:"manifest_cluster"`
	ManifestNode                string  `json:"manifest_node"`
	ManifestNodeType            string  `json:"manifest_node_type"`
	Muted                       bool    `json:"muted"`
	Node                        string  `json:"node"`
	Platform                    string  `json:"platform"`
	PlaySessionID               string  `json:"play_session_id"`
	Player                      string  `json:"player"`
	Quality                     string  `json:"quality"`
	ServingID                   string  `json:"serving_id"`
	StreamFormat                string  `json:"stream_format"`
	Time                        float64 `json:"time"`
	TimeSinceLoadStart          int     `json:"time_since_load_start"`
	TimeToMasterPlaylistReady   int     `json:"time_to_master_playlist_ready"`
	TimeToMasterPlaylistRequest int     `json:"time_to_master_playlist_request"`
	TimeToPlayAttempt           int     `json:"time_to_play_attempt"`
	TimeToSegmentReady          int     `json:"time_to_segment_ready"`
	TimeToSegmentRequest        int     `json:"time_to_segment_request"`
	TimeToVariantReady          int     `json:"time_to_variant_ready"`
	TimeToVariantRequest        int     `json:"time_to_variant_request"`
	TranscoderType              string  `json:"transcoder_type"`
	URL                         string  `json:"url"`
	VidHeight                   int     `json:"vid_height"`
	VidWidth                    int     `json:"vid_width"`
	VideoBufferSize             float64 `json:"video_buffer_size"`
	Volume                      int     `json:"volume"`
}

type ABSStreamFormatChange struct {
	Backend                    string  `json:"backend"`
	BroadcastID                string  `json:"broadcast_id"`
	BufferLevel                int     `json:"buffer_level"`
	ChannelID                  string  `json:"channel_id"`
	Cluster                    string  `json:"cluster"`
	CoreVersion                string  `json:"core_version"`
	CurrentBitrate             int     `json:"current_bitrate"`
	CurrentStreamFormatBitrate int     `json:"current_stream_format_bitrate"`
	DeviceID                   string  `json:"device_id"`
	EstimatedBandwidth         int     `json:"estimated_bandwidth"`
	Live                       bool    `json:"live"`
	LowLatency                 bool    `json:"low_latency"`
	ManifestCluster            string  `json:"manifest_cluster"`
	ManifestNode               string  `json:"manifest_node"`
	ManifestNodeType           string  `json:"manifest_node_type"`
	Muted                      bool    `json:"muted"`
	Node                       string  `json:"node"`
	Platform                   string  `json:"platform"`
	PlaySessionID              string  `json:"play_session_id"`
	Player                     string  `json:"player"`
	Quality                    string  `json:"quality"`
	ServingID                  string  `json:"serving_id"`
	StreamFormat               string  `json:"stream_format"`
	TranscoderType             string  `json:"transcoder_type"`
	URL                        string  `json:"url"`
	VidHeight                  int     `json:"vid_height"`
	VidWidth                   int     `json:"vid_width"`
	VideoBufferSize            float64 `json:"video_buffer_size"`
	Volume                     int     `json:"volume"`
}

type NSecondPlay struct {
	Backend          string  `json:"backend"`
	BroadcastID      string  `json:"broadcast_id"`
	ChannelID        string  `json:"channel_id"`
	Cluster          string  `json:"cluster"`
	CoreVersion      string  `json:"core_version"`
	CurrentBitrate   int     `json:"current_bitrate"`
	CurrentFps       int     `json:"current_fps"`
	DeviceID         string  `json:"device_id"`
	Live             bool    `json:"live"`
	LowLatency       bool    `json:"low_latency"`
	ManifestCluster  string  `json:"manifest_cluster"`
	ManifestNode     string  `json:"manifest_node"`
	ManifestNodeType string  `json:"manifest_node_type"`
	Muted            bool    `json:"muted"`
	Node             string  `json:"node"`
	Platform         string  `json:"platform"`
	PlaySessionID    string  `json:"play_session_id"`
	Player           string  `json:"player"`
	Quality          string  `json:"quality"`
	SecondsAfterPlay float64 `json:"seconds_after_play"`
	ServingID        string  `json:"serving_id"`
	StreamFormat     string  `json:"stream_format"`
	TranscoderType   string  `json:"transcoder_type"`
	URL              string  `json:"url"`
	VidHeight        int     `json:"vid_height"`
	VidWidth         int     `json:"vid_width"`
	VideoBufferSize  float64 `json:"video_buffer_size"`
	Volume           int     `json:"volume"`
}

type BufferEmpty struct {
	Backend          string  `json:"backend"`
	BroadcastID      string  `json:"broadcast_id"`
	BufferEmptyCount int     `json:"buffer_empty_count"`
	BufferSessionID  string  `json:"buffer_session_id"`
	ChannelID        string  `json:"channel_id"`
	Cluster          string  `json:"cluster"`
	CoreVersion      string  `json:"core_version"`
	CurrentBitrate   int     `json:"current_bitrate"`
	CurrentFps       int     `json:"current_fps"`
	DeviceID         string  `json:"device_id"`
	Live             bool    `json:"live"`
	LowLatency       bool    `json:"low_latency"`
	ManifestCluster  string  `json:"manifest_cluster"`
	ManifestNode     string  `json:"manifest_node"`
	ManifestNodeType string  `json:"manifest_node_type"`
	Muted            bool    `json:"muted"`
	Node             string  `json:"node"`
	Platform         string  `json:"platform"`
	PlaySessionID    string  `json:"play_session_id"`
	Player           string  `json:"player"`
	Quality          string  `json:"quality"`
	ServingID        string  `json:"serving_id"`
	StreamFormat     string  `json:"stream_format"`
	Time             float64 `json:"time"`
	TranscoderType   string  `json:"transcoder_type"`
	URL              string  `json:"url"`
	VidHeight        int     `json:"vid_height"`
	VidWidth         int     `json:"vid_width"`
	VideoBufferSize  float64 `json:"video_buffer_size"`
	Volume           int     `json:"volume"`
}

type Buffer2Seconds struct {
	Backend          string  `json:"backend"`
	BroadcastID      string  `json:"broadcast_id"`
	BufferEmptyCount int     `json:"buffer_empty_count"`
	BufferSessionID  string  `json:"buffer_session_id"`
	BufferTimeOffset int     `json:"buffer_time_offset"`
	ChannelID        string  `json:"channel_id"`
	Cluster          string  `json:"cluster"`
	CoreVersion      string  `json:"core_version"`
	CurrentBitrate   int     `json:"current_bitrate"`
	CurrentFps       int     `json:"current_fps"`
	DeviceID         string  `json:"device_id"`
	Live             bool    `json:"live"`
	LowLatency       bool    `json:"low_latency"`
	ManifestCluster  string  `json:"manifest_cluster"`
	ManifestNode     string  `json:"manifest_node"`
	ManifestNodeType string  `json:"manifest_node_type"`
	Muted            bool    `json:"muted"`
	Node             string  `json:"node"`
	Platform         string  `json:"platform"`
	PlaySessionID    string  `json:"play_session_id"`
	Player           string  `json:"player"`
	Quality          string  `json:"quality"`
	SecondsBuffered  float64 `json:"seconds_buffered"`
	ServingID        string  `json:"serving_id"`
	StreamFormat     string  `json:"stream_format"`
	TranscoderType   string  `json:"transcoder_type"`
	URL              string  `json:"url"`
	VidHeight        int     `json:"vid_height"`
	VidWidth         int     `json:"vid_width"`
	VideoBufferSize  float64 `json:"video_buffer_size"`
	Volume           int     `json:"volume"`
}

type MinuteWatched struct {
	AverageBitrate            int     `json:"average_bitrate"`
	Backend                   string  `json:"backend"`
	BroadcastID               string  `json:"broadcast_id"`
	ChannelID                 string  `json:"channel_id"`
	Cluster                   string  `json:"cluster"`
	CoreVersion               string  `json:"core_version"`
	CurrentBitrate            int     `json:"current_bitrate"`
	CurrentFps                int     `json:"current_fps"`
	DecodedFrames             int     `json:"decoded_frames"`
	DeviceID                  string  `json:"device_id"`
	DroppedFrames             int     `json:"dropped_frames"`
	EstimatedBandwidth        int     `json:"estimated_bandwidth"`
	FrameVariance             int     `json:"frame_variance"`
	HlsLatencyBroadcaster     int     `json:"hls_latency_broadcaster"`
	HlsLatencyIngest          int     `json:"hls_latency_ingest"`
	Live                      bool    `json:"live"`
	LowLatency                bool    `json:"low_latency"`
	ManifestCluster           string  `json:"manifest_cluster"`
	ManifestNode              string  `json:"manifest_node"`
	ManifestNodeType          string  `json:"manifest_node_type"`
	MinutesLogged             int     `json:"minutes_logged"`
	Muted                     bool    `json:"muted"`
	Node                      string  `json:"node"`
	Platform                  string  `json:"platform"`
	PlaySessionID             string  `json:"play_session_id"`
	PlaybackRate              int     `json:"playback_rate"`
	Player                    string  `json:"player"`
	Quality                   string  `json:"quality"`
	RenderedFrames            int     `json:"rendered_frames"`
	SecondsOffset             float64 `json:"seconds_offset"`
	ServingID                 string  `json:"serving_id"`
	StreamFormat              string  `json:"stream_format"`
	Time                      float64 `json:"time"`
	TranscoderType            string  `json:"transcoder_type"`
	TransportDownloadBytes    int     `json:"transport_download_bytes"`
	TransportDownloadDuration int     `json:"transport_download_duration"`
	TransportFirstByteLatency int     `json:"transport_first_byte_latency"`
	TransportSegmentDuration  int     `json:"transport_segment_duration"`
	TransportSegments         int     `json:"transport_segments"`
	URL                       string  `json:"url"`
	VidHeight                 int     `json:"vid_height"`
	VidWidth                  int     `json:"vid_width"`
	VideoBufferSize           float64 `json:"video_buffer_size"`
	Volume                    int     `json:"volume"`
}

type BufferRefill struct {
	Backend          string  `json:"backend"`
	BroadcastID      string  `json:"broadcast_id"`
	BufferEmptyCount int     `json:"buffer_empty_count"`
	BufferSessionID  string  `json:"buffer_session_id"`
	BufferingTime    float64 `json:"buffering_time"`
	ChannelID        string  `json:"channel_id"`
	Cluster          string  `json:"cluster"`
	CoreVersion      string  `json:"core_version"`
	CurrentBitrate   int     `json:"current_bitrate"`
	CurrentFps       int     `json:"current_fps"`
	DeviceID         string  `json:"device_id"`
	Live             bool    `json:"live"`
	LowLatency       bool    `json:"low_latency"`
	ManifestCluster  string  `json:"manifest_cluster"`
	ManifestNode     string  `json:"manifest_node"`
	ManifestNodeType string  `json:"manifest_node_type"`
	Muted            bool    `json:"muted"`
	Node             string  `json:"node"`
	Platform         string  `json:"platform"`
	PlaySessionID    string  `json:"play_session_id"`
	Player           string  `json:"player"`
	Quality          string  `json:"quality"`
	ServingID        string  `json:"serving_id"`
	StreamFormat     string  `json:"stream_format"`
	Time             float64 `json:"time"`
	TranscoderType   string  `json:"transcoder_type"`
	URL              string  `json:"url"`
	VidHeight        int     `json:"vid_height"`
	VidWidth         int     `json:"vid_width"`
	VideoBufferSize  float64 `json:"video_buffer_size"`
	Volume           int     `json:"volume"`
}

type VideoError struct {
	Backend               string  `json:"backend"`
	CoreVersion           string  `json:"core_version"`
	DeviceID              string  `json:"device_id"`
	Muted                 bool    `json:"muted"`
	Platform              string  `json:"platform"`
	Player                string  `json:"player"`
	Quality               string  `json:"quality"`
	Time                  float64 `json:"time"`
	VideoBufferSize       int     `json:"video_buffer_size"`
	VideoErrorCode        int     `json:"video_error_code"`
	VideoErrorMessage     string  `json:"video_error_message"`
	VideoErrorRecoverable bool    `json:"video_error_recoverable"`
	VideoErrorResult      string  `json:"video_error_result"`
	VideoErrorSource      string  `json:"video_error_source"`
	VideoErrorValue       int     `json:"video_error_value"`
	Volume                int     `json:"volume"`
}
