package playercore

import "encoding/json"

// Parsing logic

func parseMasterManifestReady(data string) (MasterManifestReady, error) {
	ns := MasterManifestReady{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return MasterManifestReady{}, err
	}
	return ns, nil
}

func parseVideoPlay(data string) (VideoPlay, error) {
	ns := VideoPlay{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return VideoPlay{}, err
	}
	return ns, nil
}

func parseABSStreamFormatChange(data string) (ABSStreamFormatChange, error) {
	ns := ABSStreamFormatChange{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return ABSStreamFormatChange{}, err
	}
	return ns, nil
}

func parseNSecondPlay(data string) (NSecondPlay, error) {
	ns := NSecondPlay{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return NSecondPlay{}, err
	}
	return ns, nil
}

func parseBufferEmpty(data string) (BufferEmpty, error) {
	ns := BufferEmpty{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return BufferEmpty{}, err
	}
	return ns, nil
}

func parseBuffer2Seconds(data string) (Buffer2Seconds, error) {
	ns := Buffer2Seconds{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return Buffer2Seconds{}, err
	}
	return ns, nil
}

func parseMinuteWatched(data string) (MinuteWatched, error) {
	ns := MinuteWatched{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return MinuteWatched{}, err
	}
	return ns, nil
}

func parseBufferRefill(data string) (BufferRefill, error) {
	ns := BufferRefill{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return BufferRefill{}, err
	}
	return ns, nil
}

func parseVideoError(data string) (VideoError, error) {
	ns := VideoError{}
	err := json.Unmarshal([]byte(data), &ns)
	if err != nil {
		return VideoError{}, err
	}
	return ns, nil
}
