package corelocation

import (
	"encoding/json"
	"fmt"
	"os/exec"
	"runtime"

	log "github.com/sirupsen/logrus"
)

type LocationResponse struct {
	HAccuracy             string `json:"h_accuracy"`
	Address               string `json:"address"`
	SubThoroughfare       string `json:"subThoroughfare"`
	Time                  string `json:"time"`
	SubLocality           string `json:"subLocality"`
	AdministrativeArea    string `json:"administrativeArea"`
	Country               string `json:"country"`
	Thoroughfare          string `json:"thoroughfare"`
	Region                string `json:"region"`
	Speed                 string `json:"speed"`
	Latitude              string `json:"latitude"`
	Name                  string `json:"name"`
	Altitude              string `json:"altitude"`
	TimeZone              string `json:"timeZone"`
	IsoCountryCode        string `json:"isoCountryCode"`
	Longitude             string `json:"longitude"`
	VAccuracy             string `json:"v_accuracy"`
	PostalCode            string `json:"postalCode"`
	Direction             string `json:"direction"`
	Locality              string `json:"locality"`
	SubAdministrativeArea string `json:"subAdministrativeArea"`
}

func Get(coreLocationCLI string) (LocationResponse, error) {
	if coreLocationCLI == "" {
		coreLocationCLI = "./bin/corelocationcli"
	}

	if runtime.GOOS == "darwin" {
		log.Info("Getting location of devices")
		out, err := exec.Command(coreLocationCLI, "-json").Output()
		if err != nil {
			mess := string(out)
			if mess == "LOCATION MANAGER ERROR: The operation couldn’t be completed. (kCLErrorDomain error 0.)\n" {
				return LocationResponse{}, fmt.Errorf("Wi-Fi not enabled, cannot log location.")
			}
			log.Error("You need to grant corelocationcli permission to collect. Open system settings -> Privacy -> Location services and check the box.")
			return LocationResponse{}, err
		}

		ns := LocationResponse{}
		err = json.Unmarshal(out, &ns)
		if err != nil {
			return LocationResponse{}, err
		}

		log.WithFields(log.Fields{
			"Latitude":  ns.Latitude,
			"Longitude": ns.Longitude,
		}).Info("Got location")

		return ns, nil
	}

	return LocationResponse{}, fmt.Errorf("Not on Mac, can't get location")
}
