package creds

import (
	"encoding/json"
	"io/ioutil"
)

type AWS struct {
	AccessKey string `json:"AccessKey"`
	Secret    string `json:"Secret"`
	Bucket    string `json:"Bucket"`
}

type Ingest struct {
	StreamKey string `json:"StreamKey"`
}

type Credentials struct {
	AWS    AWS    `json:"AWS"`
	Ingest Ingest `json:"Ingest"`
}

func Load(file string) (*Credentials, error) {
	if file == "" {
		file = "creds.json"
	}
	b, err := ioutil.ReadFile(file)
	if err != nil {
		return &Credentials{}, err
	}

	ns := Credentials{}
	err = json.Unmarshal(b, &ns)
	if err != nil {
		return nil, err
	}

	return &ns, nil
}
