// +build !linux

package finish

import (
	"fmt"
	"log"
	"os"
	"os/exec"
	"time"

	"github.com/faiface/beep"
	"github.com/faiface/beep/mp3"
	"github.com/faiface/beep/speaker"
)

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//    ____  _     _____    _    ____  _____
//   |  _ \| |   | ____|  / \  / ___|| ____|
//   | |_) | |   |  _|   / _ \ \___ \|  _|
//   |  __/| |___| |___ / ___ \ ___) | |___
//   |_|   |_____|_____/_/   \_\____/|_____|
//
//    ___ ____ _   _  ___  ____  _____
//   |_ _/ ___| \ | |/ _ \|  _ \| ____|
//    | | |  _|  \| | | | | |_) |  _|
//    | | |_| | |\  | |_| |  _ <| |___
//   |___\____|_| \_|\___/|_| \_\_____|
//
//    _____ _   _ ___ ____
//   |_   _| | | |_ _/ ___|
//     | | | |_| || |\___ \
//     | | |  _  || | ___) |
//     |_| |_| |_|___|____/
//
//    _____ ___ _     _____
//   |  ___|_ _| |   | ____|
//   | |_   | || |   |  _|
//   |  _|  | || |___| |___
//   |_|   |___|_____|_____|
//
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////

func Finish(file string) {
	if file == "" {
		file = "polar.mp3"
	}
	cmd := exec.Command("/usr/bin/osascript", "-e", `set Volume "50"`)
	err := cmd.Start()
	if err != nil {
		fmt.Println(err)
	}

	f, err := os.Open(file)
	if err != nil {
		log.Fatal(err)
	}

	streamer, format, err := mp3.Decode(f)
	if err != nil {
		log.Fatal(err)
	}
	defer streamer.Close()

	speaker.Init(format.SampleRate, format.SampleRate.N(time.Second/10))

	done := make(chan bool)
	speaker.Play(beep.Seq(streamer, beep.Callback(func() {
		done <- true
	})))

	<-done
}
