package testplaylist

import (
	"encoding/json"
	"io/ioutil"
)

type TestPlaylist struct {
	Playlist []ModuleConfig `json:"playlist"`
}

type ModuleConfig struct {
	Module      string            `json:"module"`
	Description string            `json:"desc"`
	Suffix      string            `json:"suffix,omitempty"`
	Config      map[string]string `json:"config"`
}

func Load(file string) (TestPlaylist, error) {
	if file == "" {
		file = "testconf.json"
	}
	b, err := ioutil.ReadFile(file)
	if err != nil {
		return TestPlaylist{}, err
	}

	ns := TestPlaylist{}
	err = json.Unmarshal(b, &ns)
	if err != nil {
		return TestPlaylist{}, err
	}

	return ns, nil
}
