package context

import (
	"log"
	"net"

	"context"
)

type key int

const (
	localAddrKey key = iota
	remoteAddrKey
	streamNameKey
	connStatusKey
	loggerKey
)

func WithLocalAddr(ctx context.Context, addr net.Addr) context.Context {
	return context.WithValue(ctx, localAddrKey, addr)
}

func GetListenAddr(ctx context.Context) (net.Addr, bool) {
	addr, ok := ctx.Value(localAddrKey).(net.Addr)
	return addr, ok
}

func WithRemoteAddr(ctx context.Context, addr net.Addr) context.Context {
	return context.WithValue(ctx, remoteAddrKey, addr)
}

func GetRemoteAddr(ctx context.Context) (net.Addr, bool) {
	addr, ok := ctx.Value(remoteAddrKey).(net.Addr)
	return addr, ok
}

func WithStreamName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, streamNameKey, name)
}

func GetStreamName(ctx context.Context) (string, bool) {
	name, ok := ctx.Value(streamNameKey).(string)
	return name, ok
}

func WithLogger(ctx context.Context, logger *log.Logger) context.Context {
	return context.WithValue(ctx, loggerKey, logger)
}

func GetLogger(ctx context.Context) (*log.Logger, bool) {
	logger, ok := ctx.Value(loggerKey).(*log.Logger)
	return logger, ok
}

func WithConnStatus(ctx context.Context, status string) context.Context {
	return context.WithValue(ctx, connStatusKey, status)
}

func GetConnStatus(ctx context.Context) (string, bool) {
	status, ok := ctx.Value(connStatusKey).(string)
	return status, ok
}
