package rtmp

import (
	"bytes"
	"code.justin.tv/event-engineering/gortmp/pkg/amf"
	"sync/atomic"
)

type Counter struct {
	val int64
}

func (c *Counter) Add(x int64) {
	atomic.AddInt64(&c.val, x)
}

func (c *Counter) Get() int64 {
	return atomic.LoadInt64(&c.val)
}

func (c *Counter) Set(x int64) {
	atomic.StoreInt64(&c.val, x)
}

func dumpAmf3(buf *bytes.Buffer) []interface{} {
	buf.ReadByte()
	return dumpAmf0(buf)
}

func dumpAmf0(buf *bytes.Buffer) []interface{} {
	var objs []interface{}
	for buf.Len() > 0 {
		obj, err := amf.ReadValue(buf)
		if err != nil {
			return objs
		}

		objs = append(objs, obj)
	}
	return objs
}

func dumpAmf(msg *RawMessage) []interface{} {
	switch msg.Type {
	case COMMAND_AMF0:
		return dumpAmf0(bytes.NewBuffer(msg.Data.Bytes()))
	case COMMAND_AMF3:
		return dumpAmf3(bytes.NewBuffer(msg.Data.Bytes()))
	default:
		return nil
	}
}

func Uint24(b []byte) uint32 {
	return uint32(b[2]) | uint32(b[1])<<8 | uint32(b[0])<<16
}

func PutUint24(b []byte, val uint32) {
	b[2] = uint8(val & 0xff)
	b[1] = uint8((val >> 8) & 0xff)
	b[0] = uint8((val >> 16) & 0xff)
}
