package findingest

import (
	"encoding/json"
	"fmt"
	"net/http"
)

// Ingest represents a single ingest result
type Ingest struct {
	Name        string `json:"name"`
	URLTemplate string `json:"url_template"`
	Priority    int    `json:"priority"`
}

type findIngestResponse struct {
	Ingests []Ingest `json:"ingests"`
}

// Find will query find-ingest to return a list of ingests ordered by best
func Find() ([]Ingest, error) {
	fiResp := &findIngestResponse{}

	resp, err := http.Get("https://ingest.twitch.tv/ingests")

	if err != nil {
		return nil, err
	}

	if resp.StatusCode != 200 {
		return nil, fmt.Errorf("Failed to call find-ingest status code: %v", resp.StatusCode)
	}

	decoder := json.NewDecoder(resp.Body)

	err = decoder.Decode(fiResp)

	if err != nil {
		return nil, err
	}

	return fiResp.Ingests, nil
}
