package rtmp

import (
	"fmt"
	"net"
	"testing"

	"code.justin.tv/event-engineering/gortmp/pkg/amf"
)

const targetStreamID = 1

// amsPublisher is a fake publisher that tries to mimic the behavior of Adobe Media Server
type amsPublisher struct {
}

func (p amsPublisher) Publish(conn net.Conn) error {
	defer conn.Close()
	pc := flushingConn{NewBasicConn(conn)}
	err := pc.Write(ConnectCommand{
		TransactionID: 1,
		Properties: amf.Object{
			"app":            "app",
			"tcURL":          "TODO",
			"flashVer":       "FlashCom/5.0.11 LNX",
			"swfURL":         "rtmp://_defaultVHost_:1935/pipe/_definst_",
			"audioCodecs":    4095,
			"videoCodecs":    255,
			"capabilities":   20,
			"type":           "nonprivate",
			"objectEncoding": 3,
		},
	})
	if err != nil {
		return err
	}

	for {
		raw, err := pc.Read()
		if err != nil {
			return fmt.Errorf("connection read error: %s", err)
		}
		msg, err := pc.parseMessage(raw)
		if err != nil {
			return fmt.Errorf("message parse error: %s", err)
		}
		resp := []Message{}
		switch msg := msg.(type) {
		case SetPeerBandwidthMessage:
			resp = append(resp, WindowAcknowledgementSizeMessage{SetPeerBandwidthMessage(msg).WindowSize})
		case StreamBeginEvent:
			// TODO verify ChunkStreamID is 2, EOF if it is not
		case ResultCommand:
			resp = append(resp, InitStreamCommand{ResultCommand(msg).TransactionID, targetStreamID})
			resp = append(resp, PublishCommand{
				StreamID:      targetStreamID,
				TransactionID: 0,
				Name:          "app",
			})
		default:
		}
		for _, m := range resp {
			if err := pc.Write(m); err != nil {
				return err
			}
		}
	}
}

func TestAmsPublisher(t *testing.T) {
	runServerPublisher(t, amsPublisher{})
}
