package rtmp

import (
	"bytes"
	crand "crypto/rand"
	"encoding/binary"
	mrand "math/rand"
	"testing"
)

func TestUint24(t *testing.T) {
	buf := make([]byte, 4)
	if _, err := crand.Read(buf[1:]); err != nil {
		t.Fatal(err)
	}

	a := binary.BigEndian.Uint32(buf)
	b := Uint24(buf[1:])
	if a != b {
		t.Fatalf("Uint24 decode failure: %d != %d", a, b)
	}
}

func TestPutUint24(t *testing.T) {
	val := mrand.Uint32() & 0xffffff
	a := make([]byte, 4)
	b := make([]byte, 4)

	binary.BigEndian.PutUint32(a, val)
	PutUint24(b[1:], val)

	if bytes.Compare(a, b) != 0 {
		t.Fatalf("Uint24 encode failure: %v != %v", a, b)
	}
}
