package main

import (
	"github.com/aws/aws-lambda-go/lambda"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/sirupsen/logrus"
	"os"

	"code.justin.tv/event-engineering/acm-ca-go/pkg/certgen"
	moonlightAWS "code.justin.tv/event-engineering/moonlight-api/pkg/aws"
	awsBackend "code.justin.tv/event-engineering/moonlight-api/pkg/aws/backend"
	db "code.justin.tv/event-engineering/moonlight-api/pkg/db"
	"code.justin.tv/event-engineering/moonlight-api/pkg/moonlight"
)

var (
	moonlightAPI *moonlight.ControlAPI
)

func init() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	sess, err := session.NewSession(&aws.Config{
		Region: aws.String("us-west-2"),
	})

	if err != nil {
		panic(err)
	}

	ab := awsBackend.New(sess)

	instancesTable := os.Getenv("instancesTableName")
	serversTable := os.Getenv("serversTableName")
	usersTable := os.Getenv("usersTableName")
	rtmpSourcesTable := os.Getenv("rtmpSourcesTableName")
	jobRunnerQueueURL := os.Getenv("jobRunnerQueueURL")
	rtmpSourceURL := os.Getenv("rtmpSourceURL")
	ecrRepositoryURL := os.Getenv("ecrRepositoryURL")
	publicMediaURL := os.Getenv("publicMediaURL")
	moonlightRootCAARN := os.Getenv("moonlightRootCAARN")

	logger.Info("Creating moonlight db")

	mdb := db.NewDynamoMoonlightDB(ab, instancesTable, serversTable, usersTable, rtmpSourcesTable, logger)
	awsClient := moonlightAWS.New(ab, logger)

	certGen := certgen.New(sess, moonlightRootCAARN)

	moonlightAPI, err = moonlight.NewControlServer(mdb, awsClient, certGen, jobRunnerQueueURL, rtmpSourceURL, ecrRepositoryURL, publicMediaURL, logger)

	if err != nil {
		panic(err)
	}
}

func main() {
	lambda.Start(moonlightAPI.Handle)
}
