package main

import (
	jobrunner "code.justin.tv/event-engineering/moonlight-api/pkg/jobrunner"
	"github.com/aws/aws-lambda-go/lambda"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/sirupsen/logrus"
	"os"

	"code.justin.tv/event-engineering/acm-ca-go/pkg/certgen"
	moonlightAWS "code.justin.tv/event-engineering/moonlight-api/pkg/aws"
	awsBackend "code.justin.tv/event-engineering/moonlight-api/pkg/aws/backend"
	db "code.justin.tv/event-engineering/moonlight-api/pkg/db"
)

var (
	logger *logrus.Logger
	runner jobrunner.Client
)

func init() {
	logger = logrus.New()
	logger.SetLevel(logrus.InfoLevel)
	logger.SetNoLock()

	sess, err := session.NewSession(&aws.Config{
		Region: aws.String("us-west-2"),
	})

	if err != nil {
		panic(err)
	}

	ab := awsBackend.New(sess)

	instancesTable := os.Getenv("instancesTableName")
	serversTable := os.Getenv("serversTableName")
	usersTable := os.Getenv("usersTableName")
	rtmpSourcesTable := os.Getenv("rtmpSourcesTableName")
	daemonASGName := os.Getenv("daemonASGName")
	moonlightRootCAARN := os.Getenv("moonlightRootCAARN")

	mdb := db.NewDynamoMoonlightDB(ab, instancesTable, serversTable, usersTable, rtmpSourcesTable, logger)
	awsClient := moonlightAWS.New(ab, logger)

	certGen := certgen.New(sess, moonlightRootCAARN)

	runner, err = jobrunner.New(mdb, awsClient, certGen, daemonASGName, logger)

	if err != nil {
		panic(err)
	}
}

func main() {
	lambda.Start(runner.Handle)
}
