package adminclient

import (
	"errors"
	"net/http"

	svc "code.justin.tv/event-engineering/moonlight-api/pkg/moonlight"
)

// HTTPClient is an interface that is fulfilled by *http.Client
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

type client struct {
	baseClient HTTPClient
}

// New returns a new Turnip client
func New(baseClient HTTPClient) HTTPClient {
	return &client{
		baseClient: baseClient,
	}
}

func (c *client) Do(req *http.Request) (*http.Response, error) {
	userID := svc.UserID(req.Context())
	if userID == "" {
		return nil, errors.New("Please provide a user ID")
	}
	req.Header.Set(svc.UserIDHeader, userID)

	return c.baseClient.Do(req)
}
