package authoriser

import (
	logging "code.justin.tv/event-engineering/golibs/pkg/logging"
	twitchBackend "code.justin.tv/event-engineering/moonlight-api/pkg/twitch/backend"
	"fmt"
)

type UserInfo struct {
	UserName string
	UserId   string
}

type Client interface {
	GetUserIdentity(oauthToken string) (*UserInfo, error)
}

type client struct {
	tw     twitchBackend.Client
	logger logging.Logger
}

func New(twitchBackend twitchBackend.Client, logger logging.Logger) Client {
	client := &client{
		tw:     twitchBackend,
		logger: logger,
	}

	return client
}

func (c *client) GetUserIdentity(oauthToken string) (*UserInfo, error) {
	validateTokenResponse, err := c.tw.ValidateToken(oauthToken)
	if err != nil {
		c.logger.Warnf("Error validating token %v", err)
		return nil, err
	}

	// Make sure that the token we've been given was generated by this application
	if c.tw.GetClientID() != validateTokenResponse.ClientID {
		return nil, fmt.Errorf("Invalid Client ID %v", validateTokenResponse.ClientID)
	}

	resp := &UserInfo{
		UserId:   validateTokenResponse.UserID,
		UserName: validateTokenResponse.Login,
	}

	return resp, nil
}
