package ca

import (
	"code.justin.tv/event-engineering/acm-ca-go/pkg/certgen"
	"crypto/x509"
)

func GetRootCAs(certGen certgen.Generator) (*x509.CertPool, error) {
	// We're using acm-ca-go to generate TLS certificates signed by a private CA, so we need to grab the private CA root cert and add it to the pool
	rootCAs, _ := x509.SystemCertPool()
	if rootCAs == nil {
		rootCAs = x509.NewCertPool()
	}

	rootCerts, err := certGen.GetRootCACert()
	if err != nil {
		return nil, err
	}

	for _, cert := range rootCerts {
		rootCAs.AddCert(cert)
	}

	return rootCAs, nil
}
