package external

import (
	"net/http"
)

// UserInfo is the public type that gets returned by the /info call
type UserInfo struct {
	UserID   string `json:"user_id"`
	UserName string `json:"user_name"`
}

func (s *handler) Info(writer http.ResponseWriter, request *http.Request) {
	user, err := getUserInfo(request)
	if err != nil {
		s.logger.Warnf("Error authenticating user %v", err)
		handleError(writer, http.StatusUnauthorized, "")
		return
	}

	sendResponse(writer, http.StatusOK, UserInfo{
		user.UserID,
		user.UserName,
	})
}
