package external

import (
	controlRPC "code.justin.tv/event-engineering/moonlight-api/pkg/rpc/control"
	"encoding/json"
	"net/http"
)

func (s *handler) Live(writer http.ResponseWriter, request *http.Request) {
	user, err := getUserInfo(request)
	if err != nil {
		s.logger.Warnf("Error authenticating user %v", err)
		handleError(writer, http.StatusUnauthorized, "")
		return
	}

	channel, err := s.twitch.GetChannel(user.TokenUsed)
	if err != nil {
		s.logger.Warnf("Failed to get user's stream key %v", err)
		handleError(writer, http.StatusBadRequest, "")
	}

	decoder := json.NewDecoder(request.Body)

	live := &LiveReq{}
	err = decoder.Decode(live)

	if err != nil {
		s.logger.Warnf("Error deserialising body %v", err)
		handleError(writer, http.StatusBadRequest, "")
	}

	resp, err := s.internal.SetStreamLive(request.Context(), &controlRPC.SetStreamLiveReq{
		TwitchUserId: user.UserID,
		Live:         live.Live,
		StreamKey:    channel.StreamKey,
	})

	if err != nil {
		s.logger.Warnf("Error executing SetStreamLive %v", err)
		handleError(writer, http.StatusInternalServerError, "")
		return
	}

	if !resp.GetSuccess() {
		s.logger.Warnf("Error executing SetStreamLive %v", err)
		handleError(writer, http.StatusInternalServerError, resp.GetMessage())
		return
	}

	sendResponse(writer, http.StatusOK, UserInfo{
		user.UserID,
		user.UserName,
	})
}
