package external

import (
	controlRPC "code.justin.tv/event-engineering/moonlight-api/pkg/rpc/control"
	"encoding/json"
	"net/http"
)

func (s *handler) SetScene(writer http.ResponseWriter, request *http.Request) {
	user, err := getUserInfo(request)
	if err != nil {
		s.logger.Warnf("Error authenticating user %v", err)
		handleError(writer, http.StatusUnauthorized, "")
		return
	}

	decoder := json.NewDecoder(request.Body)

	setScene := &SetSceneReq{}
	err = decoder.Decode(setScene)

	if err != nil {
		s.logger.Warnf("Error deserialising body %v", err)
		handleError(writer, http.StatusBadRequest, "")
	}

	resp, err := s.internal.SetStreamScene(request.Context(), &controlRPC.SetStreamSceneReq{
		TwitchUserId:    user.UserID,
		SceneIdentifier: setScene.SceneIdentifier,
	})

	if err != nil {
		s.logger.Warnf("Error executing SetStreamScene %v", err)
		handleError(writer, http.StatusInternalServerError, "")
		return
	}

	if !resp.GetSuccess() {
		s.logger.Warnf("Error executing SetStreamScene %v", err)
		handleError(writer, http.StatusInternalServerError, resp.GetMessage())
		return
	}

	sendResponse(writer, http.StatusOK, UserInfo{
		user.UserID,
		user.UserName,
	})
}
