package external

import (
	controlRPC "code.justin.tv/event-engineering/moonlight-api/pkg/rpc/control"
	"github.com/twitchtv/twirp"
	"net/http"
)

func (s *handler) Status(writer http.ResponseWriter, request *http.Request) {
	user, err := getUserInfo(request)
	if err != nil {
		s.logger.Warnf("Error authenticating user %v", err)
		handleError(writer, http.StatusUnauthorized, "")
		return
	}

	resp, err := s.internal.GetInstanceStatus(request.Context(), &controlRPC.GetInstanceStatusReq{
		TwitchUserId: user.UserID,
	})

	if err != nil {
		if twerr, ok := err.(twirp.Error); ok {
			switch twerr.Code() {
			case twirp.NotFound:
				handleError(writer, http.StatusNotFound, twerr.Msg())
			}
		}

		s.logger.Warnf("Error executing GetInstanceStatus %v", err)
		handleError(writer, http.StatusInternalServerError, "")
		return
	}

	sendResponse(writer, http.StatusOK, StatusResp{
		Status:        resp.Status,
		RTMPMuted:     resp.RtmpMuted,
		HeartbeatJson: resp.HeartbeatJson,
	})
}
