package external

type LiveReq struct {
	Live bool `json:"live"`
}

type MuteReq struct {
	Mute bool `json:"mute"`
}

type SetSceneReq struct {
	SceneIdentifier string `json:"scene_identifier"`
}

type InitialiseSessionResp struct {
	Config       StreamConfig `json:"config"`
	InstanceInfo StatusResp   `json:"instance_info"`
}

type StreamConfig struct {
	Scenes []string `json:"scenes"`
}

type StatusResp struct {
	Status        string `json:"status"`
	RTMPMuted     bool   `json:"rtmp_muted"`
	HeartbeatJson string `json:"heartbeat_json"`
}

type UpdateOBSConfigReq struct {
	MainOverlayURL    string `json:"main_overlay_url"`
	MainOverlayWidth  int32  `json:"main_overlay_width"`
	MainOverlayHeight int32  `json:"main_overlay_height"`
	MainOverlayX      int32  `json:"main_overlay_x"`
	MainOverlayY      int32  `json:"main_overlay_y"`
}
