package interop

// CloudCompositeStatus represents the current status of the Cloud Composite service
type CloudCompositeStatus struct {
	IsStreaming        bool
	CurrentBitrateKbps int
	CurrentScene       string
}

type SceneList struct {
	CurrentScene string
	Scenes       []string
}

// CloudComposite is an interface defining functions that all cloud composite services should implement
// But I'm sacking this idea off because we're just using OBS, the original idea was that this could be interchangable
// With other things, but nah
type CloudComposite interface {
	StartStream(streamKey string) error
	StopStream() error
	GetSceneList() (*SceneList, error)
	SwitchScene(sceneIdentifier string) error
	GetStatus() (*CloudCompositeStatus, error)
	Close() error
	Connect() error
}
