package jobrunner

type MessageType int

const (
	AllocateServer MessageType = iota
	CheckConsistency
	CheckScaling
)

func (s MessageType) String() string {
	return [...]string{"ALLOCATE_SERVER", "CHECK_CONSISTENCY", "CHECK_SCALING"}[s]
}

type AllocateServerMessage struct {
	InstanceID string `json:"instance_id"`
}

type EventPayload struct {
	JobType string `json:"job_type"`
}
