package moonlight

import (
	"crypto/tls"
	"net/http"

	"code.justin.tv/event-engineering/acm-ca-go/pkg/certgen"
	aws "code.justin.tv/event-engineering/moonlight-api/pkg/aws"
	"code.justin.tv/event-engineering/moonlight-api/pkg/ca"
	db "code.justin.tv/event-engineering/moonlight-api/pkg/db"
	"code.justin.tv/video/brassclient"
	"github.com/sirupsen/logrus"
)

type AdminAPI struct {
	logger logrus.FieldLogger
	db     db.MoonlightDB
	aws    *aws.Client
	//	twirpHandler      http.Handler
	daemonHttpClient  *http.Client
	publicMediaURL    string
	jobRunnerQueueURL string
	rtmpSourceURL     string
	ecrRepositoryURL  string
	bindleLockConfig  BindleLockConfig
	brass             *brassclient.BRASS
}

func NewAdminServer(db db.MoonlightDB, aws *aws.Client, certGen certgen.Generator, jobRunnerQueueURL, rtmpSourceURL, ecrRepositoryURL, publicMediaURL string, brass *brassclient.BRASS, bindleLockConfig BindleLockConfig, logger logrus.FieldLogger) (*AdminAPI, error) {
	// We're using acm-ca-go to generate TLS certificates signed by a private CA, so we need to grab the private CA root cert and add it to the pool
	rootCAs, err := ca.GetRootCAs(certGen)
	if err != nil {
		return nil, err
	}

	server := &AdminAPI{
		logger:            logger,
		db:                db,
		aws:               aws,
		jobRunnerQueueURL: jobRunnerQueueURL,
		publicMediaURL:    publicMediaURL,
		rtmpSourceURL:     rtmpSourceURL,
		ecrRepositoryURL:  ecrRepositoryURL,
		brass:             brass,
		bindleLockConfig:  bindleLockConfig,
		daemonHttpClient: &http.Client{
			Transport: &http.Transport{
				TLSClientConfig: &tls.Config{
					RootCAs: rootCAs,
				},
			},
		},
	}

	return server, nil
}
