package moonlight

import (
	"context"
	"fmt"

	"code.justin.tv/video/brassclient"
	"github.com/twitchtv/twirp"
)

type BindleLockConfig struct {
	AdminBindleLockID           string
	OpsBindleLockID             string
	CanAccessSystemBindleLockID string
}

const accessDeniedError = "You do not have permission to perform this action"

func (api *AdminAPI) hasPermission(ctx context.Context, bindleLockID string) (bool, error) {
	// This happens when testing on dev so just allow it
	if api.brass == nil {
		return true, nil
	}

	userID := UserID(ctx)
	if userID == "" {
		return false, twirp.NewError(twirp.Malformed, fmt.Sprintf("Please provide a user identifier in the header %v", UserIDHeader))
	}

	resp, err := api.brass.IsAuthorized(ctx, &brassclient.IsAuthorizedRequest{
		Operation: brassclient.OperationUnlock,
		Actor: &brassclient.ActorReference{
			Type: brassclient.ActorTypePrincipal,
			ID:   userID,
		},
		Resource: &brassclient.ResourceReference{
			Type:      brassclient.ResourceTypeLock,
			Namespace: brassclient.NamespaceBindle,
			Name:      bindleLockID,
		},
	})

	if err != nil {
		api.logger.WithError(err).Error("Unable to determine user permissions")
		return false, twirp.InternalError("Unable to determine user permissions")
	}

	return resp.Authorized, nil
}
