package obs

import (
	"bytes"
	"github.com/gobuffalo/packr"
	"log"
	"text/template"
)

type OBSTemplateRepl struct {
	BRBBrowserSource         string
	RtmpSourceUrl            string
	AudioDeviceId            string
	AudioDeviceDeviceId      string
	MainOverlayBrowserSource string
	MainOverlayWidth         string
	MainOverlayHeight        string
	MainOverlayX             string
	MainOverlayY             string
}

func GenerateOBSScenes(config OBSTemplateRepl) (string, error) {
	box := packr.NewBox("./templates")

	templateString, err := box.FindString("scenes.json")
	if err != nil {
		log.Println(err)
		return "", err
	}

	tmpl, err := template.New("scenes.json").Parse(templateString)
	if err != nil {
		return "", err
	}

	buf := new(bytes.Buffer)

	err = tmpl.Execute(buf, config)
	if err != nil {
		return "", err
	}

	return buf.String(), nil
}
