package twitch

import (
	logging "code.justin.tv/event-engineering/golibs/pkg/logging"
	"code.justin.tv/event-engineering/moonlight-api/pkg/twitch/backend"
)

// New generates a new Twitch Client with the supplied backend
func New(twitchClient backend.Client, logger logging.Logger) *Client {
	return &Client{
		twitch:   twitchClient,
		logger: logger,
	}
}

// Client is a Twitch client containing methods for use in moonlight
type Client struct {
	twitch backend.Client
	logger logging.Logger
}

func (c *Client) GetChannel(token string) (backend.GetChannelResponse, error) {
	return c.twitch.GetChannel(token)
}
