#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import 'source-map-support/register';
import { MoonlightAppStack } from '../lib/moonlight-app-stack';
import { MoonlightCSPStack } from '../lib/moonlight-csp-stack';

const app = new cdk.App();
new MoonlightCSPStack(app, 'app-csp-dev', {
  env: {
    region: 'us-east-1',
    account: '450786683468',
  }
})

new MoonlightAppStack(app, 'app-dev', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '450786683468',
    }
  },
  appProps: {
    cspFunctionArn: 'arn:aws:lambda:us-east-1:450786683468:function:app-csp-dev-CSPLambdaFBC89DBB-5FOF4STEHBO6:4',
    appDomainName: 'stg.moonlight.twitch.tv',
    hostedZoneName: 'stg.moonlight.twitch.tv',
  }
});

new MoonlightCSPStack(app, 'app-csp-prod', {
  env: {
    region: 'us-east-1',
    account: '638444536247',
  }
})

new MoonlightAppStack(app, 'app-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '638444536247',
    },
    terminationProtection: true,
  },
  appProps: {
    cspFunctionArn: 'arn:aws:lambda:us-east-1:638444536247:function:app-csp-prod-CSPLambdaFBC89DBB-EIKK56VNH2UW:1',
    appDomainName: 'moonlight.twitch.tv',
    hostedZoneName: 'moonlight.twitch.tv',
  }
});
