import cdk = require('@aws-cdk/core');
import app = require('./moonlight-app/moonlight-app');

export interface StackProps {
  cdkProps: cdk.StackProps;
  appProps: app.MoonlightAppProps
}

export class MoonlightAppStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: StackProps) {
    super(scope, id, props.cdkProps);

    new app.MoonlightApp(this, 'MoonlightApp', props.appProps);
  }
}
