const fs = require('fs');
const path = require('path');
const inquirer = require('inquirer');
const handlebars = require('handlebars');

const args = process.argv.slice(2);

if (args.length === 0) {
  interactiveMode();
  return;
} else {
  doThingsWithArgs(args);
}

async function interactiveMode() {
  console.log(`
~^*-_-*^~~^*-_-*^~~^*-_-*^~
Welcome to the generator!
~^*-_-*^~~^*-_-*^~~^*-_-*^~
  `)

  const nameInput = await inquirer.prompt({
    type: 'input',
    name: 'value',
    message: "Name your component in Pascal case (i.e. SuperFunBox):",
  });

  doThingsWithArgs([
    nameInput.value,
  ]);
}

function doThingsWithArgs(args) {
  generateComponent(args[0]);
}


function generateComponent(nameComponent) {
  const templatePath = path.resolve(__dirname, 'templates', 'component.template');
  const targetDir = path.join(process.cwd(), 'src', 'components', toHyphens(nameComponent));
  const targetFile = path.join(targetDir, 'component.tsx');

  if (fs.existsSync(targetDir)){
    return console.log(`⚠️ Directory already exists: ${targetDir}`);
  }

  if (!nameComponent.substring(0, 1).match(/[A-Z]/)) {
    return console.log(`<name> must be PascalCase: ${nameComponent}`);
  }

  const templateVars = {
    nameComponent
  };

  fs.mkdirSync(targetDir);
  fs.writeFileSync(
    targetFile,
    handlebars.compile(fs.readFileSync(templatePath, 'utf8'))(templateVars)
  );

  console.log(`
Component created. Use it like this:

    import { ${nameComponent} } from '${targetFile.replace(process.cwd()+'/src', 'ui-prototype-tool')}';

    <${nameComponent} />
  `);
}

function toHyphens(s) {
  return s.replace(/(?:^|\.?)([A-Z])/g, (x, y) => '-' + y.toLowerCase()).replace(/^-/, '')
}

function toSpaces(s) {
  return s.replace(/(?:^|\.?)([A-Z])/g, (x, y) => ' ' + y).replace(/^ /, '')
}

function toFirstLower(s) {
  return s.charAt(0).toLowerCase() + s.slice(1);
}

function toPascal(s) {
  return s.match(/[a-z]+/gi).map((word) => word.charAt(0).toUpperCase() + word.substr(1).toLowerCase()).join('');
}
