import { ConnectedRouter } from 'connected-react-router';
import { push, RouterState } from "connected-react-router";
import { OidcState } from 'moonlight';
import { NavBarContainer } from "moonlight/components/nav-bar";
import { CallbackPage } from "moonlight/components/oidc/callback";
import { LoginPage } from "moonlight/components/oidc/login";
import { SilentRenew } from "moonlight/components/oidc/silent_renew";
import { AppContainer } from "moonlight/pages/app_container";
import { SettingsContainer } from "moonlight/pages/settings_container";
import { GlobalState, history, store } from 'moonlight/utils/reduxStore';
import * as React from "react";
import { connect } from 'react-redux';
import { BrowserRouter as Router, Route, Switch } from "react-router-dom";
import { Dispatch } from 'redux';
import "./App.scss";

// We bring in all Core-UI exports to make consuming them straight forward for all audiences.
import {
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  Layout,
  Position,
  ZIndex
} from "twitch-core-ui";

export interface PublicProps { }

export interface ReduxStateProps {
  oidc: OidcState;
  router: RouterState;
}

export interface ReduxDispatchProps {
  dispatch: Dispatch;
}

export type Props = PublicProps & ReduxStateProps & ReduxDispatchProps;

interface State { }

class AppComponent extends React.Component<Props, State> {
  public render() {
    if (!this.props.oidc || this.props.oidc.isLoadingUser) {
      return (
        <CoreText>Loading</CoreText>
      );
    }

    if (this.props.router.location.pathname == '/callback') {
      return (
        <ConnectedRouter history={history}>
          <Switch>
            <Route exact path="/callback" component={CallbackPage} />
          </Switch>
        </ConnectedRouter>
      );
    }

    if (this.props.router.location.pathname == '/silent_renew') {
      return (
        <ConnectedRouter history={history}>
          <Switch>
            <Route exact path="/silent_renew" component={SilentRenew} />
          </Switch>
        </ConnectedRouter>
      );
    }

    // Check user
    if (!this.props.oidc.user || this.props.oidc.user.expired) {
      return (
        <LoginPage />
      );
    }

    return (
      <ConnectedRouter history={history} >
        <Layout fullHeight display={Display.Flex} flexDirection={FlexDirection.Column} flexWrap={FlexWrap.Wrap}>
          <Layout fullWidth zIndex={ZIndex.Above} position={Position.Relative}>
            <NavBarContainer />
          </Layout>
          <Layout fullWidth flexGrow={1} position={Position.Relative}>
            <Layout fullHeight fullWidth position={Position.Absolute}>
              <Switch>
                <Route exact path="/" component={AppContainer} />
                <Route exact path="/settings" component={SettingsContainer} />
              </Switch>
            </Layout>
          </Layout>
        </Layout>
      </ConnectedRouter >
    );
  }
}

function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    oidc: state.oidc,
    router: state.router,
  };
}

function mapDispatchToProps(dispatch: Dispatch): ReduxDispatchProps {
  return {
    dispatch
  };
}

export const App = connect(mapStateToProps, mapDispatchToProps)(AppComponent);
