import * as React from 'react';
import { AlignItems, Background, BorderRadius, Button, ButtonSize, ButtonState, ButtonType, Color, CoreText, Display, InjectStyledLayout, Interactable, Layout, StyledLayout, SVGAsset } from 'twitch-core-ui';
import "./massive-button.scss";

interface Props {
  onClick: () => Promise<boolean>;
  disabled?: boolean;
  title: string;
  subtitle?: string;
  selected: boolean;
}

interface State {
  loading: boolean;
  failed: boolean;
  probablyDone: boolean;
}

export class MassiveButton extends React.Component<Props, State>  {
  constructor(props: Props, state: State) {
    super(props, state);

    this.state = {
      loading: false,
      failed: false,
      probablyDone: false,
    };
  }

  public render() {
    let buttonType = ButtonType.Secondary;

    if (this.props.selected) {
      buttonType = ButtonType.Default;

      // We're fully selected so remove probablyDone if it's there
      if (this.state.probablyDone) {
        this.setState({
          probablyDone: false,
        });
      }
    } else if (this.state.probablyDone) {
      buttonType = ButtonType.Success;
    }

    let buttonIcon = undefined;

    if (this.state.failed) {
      buttonType = ButtonType.Alert;
      buttonIcon = SVGAsset.NotificationWarning;
    }

    return (
      <Layout
        display={Display.Flex}
        flexGrow={1}
        padding={1}
        className="massive-button-container"
      >
        <Button fullWidth onClick={(event: React.MouseEvent<HTMLElement>) => this.onClick(event)} icon={buttonIcon} disabledInteraction={this.props.selected} disabled={this.props.disabled} state={this.state.loading ? ButtonState.Loading : ButtonState.Default} type={buttonType} size={ButtonSize.Large} title={this.props.title}>
          {this.props.title}
        </Button>
      </Layout>
    );
  }

  private async onClick(event: React.MouseEvent<HTMLElement>) {
    this.setState({
      loading: true
    });

    let result = await this.props.onClick();

    this.setState({
      loading: false,
      failed: !result,
      probablyDone: result,
    });

    setTimeout(() => {
      this.setState({
        failed: false,
      });
    }, 1000);
  }
}
