import * as classNames from "classnames";
import { ThemeSwitcher } from "moonlight/components/theme-switcher";
import * as React from "react";
import { NavLink } from 'react-router-dom';
import {
  AlignItems,
  Background,
  Color,
  CoreText,
  Display,
  Interactable,
  Layout,
  Overflow,
  Position,
  StyledLayout,
  SVG,
  SVGAsset,
  ZIndex
} from "twitch-core-ui";
import "./user-menu-dropdown.scss";

interface Props {
  dropdownOpen: boolean;
  logout: () => void;
  closeDropdown: () => void;
}

export class UserMenuDropdown extends React.Component<Props, {}> {
  public render() {
    const dropdownClassname = classNames("top-nav_user-info-dropdown", {
      "top-nav_user-info-dropdown--toggled": this.props.dropdownOpen
    });

    return (
      <StyledLayout
        overflow={Overflow.Hidden}
        position={Position.Absolute}
        className={dropdownClassname}
        background={Background.Alt}
        color={Color.Base}
        attachRight
        fullWidth
        zIndex={ZIndex.Below}
        padding={{ top: 1, bottom: 1 }}
        elevation={3}
      >
        <Layout margin={{ x: 2, bottom: 1 }}>
          <ThemeSwitcher
            availableThemes={[
              {
                label: "Light",
                className: "tw-root--theme-light",
                default: true
              },
              { label: "Dark", className: "tw-root--theme-dark" }
            ]}
          />
        </Layout>
        <StyledLayout borderBottom margin={{ x: 2, y: 1 }} />
        <NavLink to="/settings" onClick={this.props.closeDropdown}>
          <StyledLayout
            display={Display.Flex}
            alignItems={AlignItems.Center}
            padding={{ x: 2, y: 0.5 }}
            color={Color.Alt}
          >
            <Layout
              display={Display.Flex}
              alignItems={AlignItems.Center}
              margin={{ right: 1 }}
            >
              <SVG asset={SVGAsset.NavSettings} height={20} width={20} />
            </Layout>
            <CoreText>Settings</CoreText>
          </StyledLayout>
        </NavLink>
        <Interactable onClick={this.props.logout}>
          <StyledLayout
            display={Display.Flex}
            alignItems={AlignItems.Center}
            padding={{ x: 2, y: 0.5 }}
            color={Color.Alt}
          >
            <Layout
              display={Display.Flex}
              alignItems={AlignItems.Center}
              margin={{ right: 1 }}
            >
              <SVG asset={SVGAsset.NavLogout} height={20} width={20} />
            </Layout>
            <CoreText>Logout</CoreText>
          </StyledLayout>
        </Interactable>
      </StyledLayout>
    );
  }
}
