import { push } from "connected-react-router";
import { userManager } from 'moonlight/components/oidc/userManager';
import * as React from "react";
import { Dispatch } from "redux";
import { CallbackComponent } from "redux-oidc";
import { CoreText, Layout, TextAlign, TextType, Typeset } from "twitch-core-ui";

export interface PublicProps { }

export interface ReduxStateProps { }

export interface ReduxDispatchProps {
  dispatch: Dispatch;
}

export type Props = PublicProps & ReduxStateProps & ReduxDispatchProps;

interface State { }

export class CallbackPageComponent extends React.Component<Props, State>  {
  public render() {

    // just redirect to '/' in both cases
    return (
      <CallbackComponent
        userManager={userManager}
        successCallback={() => this.props.dispatch(push("/"))}
        errorCallback={(error) => {
          this.props.dispatch(push("/"));
          console.error(error);
        }}
      >
        <Layout textAlign={TextAlign.Center} padding={5}>
          <Typeset>
            <CoreText type={TextType.H3}>Please wait while we log you in</CoreText>
          </Typeset>
        </Layout>
      </CallbackComponent>
    );
  }
}
