import { push } from "connected-react-router";
import { userManager } from 'moonlight/components/oidc/userManager';
import * as React from "react";
import { Dispatch } from "redux";
import { CallbackComponent } from "redux-oidc";
import { Button, CoreText, Layout, TextAlign, TextType, Typeset } from "twitch-core-ui";

export interface PublicProps { }

export interface ReduxStateProps { }

export interface ReduxDispatchProps {
  dispatch: Dispatch;
}

export type Props = PublicProps & ReduxStateProps & ReduxDispatchProps;

interface State { }

export class LoginPageComponent extends React.Component<Props, State>  {
  public render() {

    // just redirect to '/' in both cases
    return (
      <Layout textAlign={TextAlign.Center} padding={5}>
        <Typeset>
          <CoreText type={TextType.H3}>Please connect your Twitch account to continue</CoreText>
          <Layout padding={5}>
            <Button onClick={this.login}>Connect with Twitch</Button>
          </Layout>
        </Typeset>
      </Layout>
    );
  }

  private login(event: React.MouseEvent<HTMLElement>) {
    event.preventDefault();
    userManager.signinRedirect();
  }
}
