import { createUserManager } from 'redux-oidc';

const userManagerConfig = {
  client_id: __OAUTH_CLIENT_ID__,
  redirect_uri: __OAUTH_REDIRECT_URL__ + '/callback',
  response_type: 'token id_token',
  scope: 'openid user_read channel_read',
  authority: 'https://id.twitch.tv/oauth2',
  silent_redirect_uri: __OAUTH_REDIRECT_URL__ + '/silent_renew',
  automaticSilentRenew: true,
  filterProtocolClaims: true,
  loadUserInfo: true,
  monitorSession: true,
};

export const userManager = createUserManager(userManagerConfig);
