import { push } from "connected-react-router";
import { API } from 'moonlight/api/api';
import { APIResponse } from 'moonlight/api/apiresponse';
import { GlobalState } from 'moonlight/utils/reduxStore';
import { Dispatch } from 'redux';
//import { InitResponse, InstanceInfo, StreamConfig } from './reducers';

export enum SettingsActions {
  UpdateOBSConfigSuccess = 'SETTINGS_UPDATE_OBS_CONFIG_SUCCESS',
  SettingsError = 'SETTINGS_ERROR',
  SettingsReset = 'SETTINGS_RESET',
}

export const settingsError = (message: string) => {
  return  {
    type: SettingsActions.SettingsError,
    data: {
      message,
    },
  };
};

export const updateOBSConfigSuccess = () => {
  return  {
    type: SettingsActions.UpdateOBSConfigSuccess,
    data: {},
  };
};

export const reset = () => {
  return  {
    type: SettingsActions.SettingsReset,
    data: {},
  };
};

export const updateOBSConfig = (obsSettings: any): any => {
  return async (dispatch: Dispatch, getState: () => GlobalState) => {
    const state = getState();
    let resp = await API.put<string>("/settings", state.oidc.user.access_token, { body: {
      main_overlay_url: obsSettings.main_overlay_url,
      main_overlay_width: obsSettings.main_overlay_width,
      main_overlay_height: obsSettings.main_overlay_height,
      main_overlay_x: obsSettings.main_overlay_x,
      main_overlay_y: obsSettings.main_overlay_y,
    }});

    // Get new value
    if (resp.isError()) {
      return dispatch(settingsError(resp.error.message));
    }

    return dispatch(push('/'));
  };
};
