import { NumberInput } from 'moonlight/components/number-input';
import { TextInput } from 'moonlight/components/text-input';
import * as React from "react";
import { NavLink } from 'react-router-dom';
import { Dispatch } from 'redux';
import { updateOBSConfig } from "./actions";

import {
  AlertBanner,
  AlertBannerType,
  Button,
  CoreText,
  Layout,
  LoadingSpinner,
  TextAlign,
  TextType,
  Typeset
} from "twitch-core-ui";
import "./settings.scss";

export interface PublicProps { }

export interface ReduxStateProps {
  errorMessage?: string;
}

export interface ReduxDispatchProps {
  dispatch: Dispatch;
  updateOBSConfig: (obsSettings: any) => {};
  reset: () => {};
}

export type Props = PublicProps & ReduxStateProps & ReduxDispatchProps;

interface State {
  saving: boolean;
  main_overlay_url: string;
  main_overlay_width?: number;
  main_overlay_height?: number;
  main_overlay_x?: number;
  main_overlay_y?: number;
}

export class SettingsComponent extends React.Component<Props, State> {
  constructor(props: Props, state: State) {
    super(props, state);

    this.state = {
      saving: false,
      main_overlay_url: undefined,
      main_overlay_width: 800,
      main_overlay_height: 600,
      main_overlay_x: 560,
      main_overlay_y: 0,
    };
  }

  public componentWillMount() {
  }

  public componentWillUnmount() {
  }

  public render() {
    if (this.props.errorMessage) {
      return (
        <Layout padding={4}>
          <AlertBanner closeButton={{ ariaLabel: 'Close', onClick: this.reset }} type={AlertBannerType.Error} message={this.props.errorMessage} />
        </Layout>
      );
    }

    if (this.state.saving) {
      return (
        <Layout padding={4}>
          <LoadingSpinner />
        </Layout>
      );
    }

    let mainOverlayPosition = (<></>);

    if (this.state.main_overlay_url) {
      mainOverlayPosition = (
        <Layout padding={{ top: 1 }}>
          <NumberInput label="Overlay Width" defaultValue={this.state.main_overlay_width} setValue={this.setMainOverlayWidth} />
          <NumberInput label="Overlay Height" defaultValue={this.state.main_overlay_height} setValue={this.setMainOverlayHeight} />
          <NumberInput label="Overlay X" defaultValue={this.state.main_overlay_x} setValue={this.setMainOverlayX} />
          <NumberInput label="Overlay Y" defaultValue={this.state.main_overlay_y} setValue={this.setMainOverlayY} />
          <Layout padding={{ top: 3 }}>
            <Button onClick={this.saveOBSConfig}>Save</Button>
          </Layout>
        </Layout>
      );
    }

    return (
      <Layout padding={3}>
        <NavLink to="/">&lt; Back</NavLink>
        <Layout padding={{ top: 3 }} textAlign={TextAlign.Left}>
          <Typeset>
            <CoreText type={TextType.H2}>Update Overlay</CoreText>
            <TextInput label="Overlay URL" setValue={this.setMainOverlayURL} />
            {mainOverlayPosition}
          </Typeset>
        </Layout>
      </Layout>
    );
  }

  private setMainOverlayURL = (mainOverlayURL: string | undefined): string | undefined => {
    this.setState({
      main_overlay_url: mainOverlayURL,
    });

    return undefined;
  }

  private setMainOverlayWidth = (mainOverlayWidth: number | undefined): string | undefined => {
    this.setState({
      main_overlay_width: mainOverlayWidth,
    });

    return undefined;
  }

  private setMainOverlayHeight = (mainOverlayHeight: number | undefined): string | undefined => {
    this.setState({
      main_overlay_height: mainOverlayHeight,
    });

    return undefined;
  }

  private setMainOverlayX = (mainOverlayX: number | undefined): string | undefined => {
    this.setState({
      main_overlay_x: mainOverlayX,
    });

    return undefined;
  }

  private setMainOverlayY = (mainOverlayY: number | undefined): string | undefined => {
    this.setState({
      main_overlay_y: mainOverlayY,
    });

    return undefined;
  }

  private reset = () => {
    this.setState({ saving: false });
    this.props.reset();
  }

  private saveOBSConfig = () => {
    this.setState({ saving: true });
    this.props.updateOBSConfig({
      main_overlay_url: this.state.main_overlay_url,
      main_overlay_width: this.state.main_overlay_width,
      main_overlay_height: this.state.main_overlay_height,
      main_overlay_x: this.state.main_overlay_x,
      main_overlay_y: this.state.main_overlay_y,
    });
  }
}
