import { GlobalState } from "moonlight/utils/reduxStore";
import { connect } from "react-redux";
import { Dispatch } from "redux";
import { reset, updateOBSConfig } from './actions';
import { ReduxDispatchProps, ReduxStateProps, SettingsComponent } from "./component";
//import { } from './reducers';

function mapDispatchToProps(dispatch: Dispatch): ReduxDispatchProps {
  return {
    dispatch,
    updateOBSConfig: (obsSettings: any) => dispatch(updateOBSConfig(obsSettings)),
    reset: () => dispatch(reset()),
  };
}

function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    errorMessage: state.settings.errorMessage
  };
}

export const SettingsContainer = connect(
  mapStateToProps,
  mapDispatchToProps
)(SettingsComponent);
