import { SettingsActions } from './actions';

export interface SettingsState {
  errorMessage?: string;
}

export const settingsReducers = (
  prevState: SettingsState = {},
  action: any,
): SettingsState => {
  const state: SettingsState = Object.assign({}, prevState);

  if (!SettingsActions) {
    return state;
  }

  switch (action.type) {
    case SettingsActions.SettingsError:
      state.errorMessage = action.data.message;
      break;
    case SettingsActions.SettingsReset:
      state.errorMessage = undefined;
      break;
  }

  return state;
};
