import { GlobalState } from "moonlight/utils/reduxStore";
import { connect } from "react-redux";
import { Dispatch } from "redux";
import { fetchInstanceStatus, fetchStreamConfig, setLiveness, setMute, setScene, StreamControlActions } from './actions';
import { ReduxDispatchProps, ReduxStateProps, StreamControl } from "./component";
import { StreamConfig } from './reducers';

function mapDispatchToProps(dispatch: Dispatch): ReduxDispatchProps {
  return {
    setScene: (sceneIdentifier: string): Promise<boolean> => dispatch(setScene(sceneIdentifier)),
    setLiveness: (live: boolean): Promise<boolean> => dispatch(setLiveness(live)),
    setMute: (muted: boolean): Promise<boolean> => dispatch(setMute(muted)),
    fetchStreamConfig: () => dispatch(fetchStreamConfig()),
    fetchInstanceStatus: () => dispatch(fetchInstanceStatus()),
  };
}

function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    config: state.streamControl.config,
    instanceInfo: state.streamControl.instanceInfo,
  };
}

export const StreamControlContainer = connect(
  mapStateToProps,
  mapDispatchToProps
)(StreamControl);
