import { fetchStreamConfig, setLiveness, setScene, StreamControlActions } from './actions';

export interface StreamConfig {
  config_found: boolean;
  scenes: string[];
}

export interface StreamControlState {
  config: StreamConfig | null;
  instanceInfo: InstanceInfo | null;
}

export enum InstanceStatus {
  New = 'NEW',
  AwaitingServer = 'AWAITING_SERVER',
  SlotReserved = 'SLOT_RESERVED',
  Registered = 'REGISTERED',
  Running = 'RUNNING',
  Healthy = 'HEALTHY',
  Unhealthy = 'UNHEALTHY',
  Errored = 'ERRORED',
  NotFound = 'NOT FOUND',
}

export interface InstanceStats {
  "fps": number;
  "render-total-frames": number;
  "render-missed-frames": number;
  "output-total-frames": number;
  "average-frame-time": number;
  "cpu-usage": number;
  "memory-usage": number;
  "free-disk-space": number;
}

export interface InstanceHeartbeat {
  "stream-timecode": string;
  "rec-timecode": string;
  "pulse": boolean;
  "current-profile": string;
  "current-scene": string;
  "streaming": boolean;
  "total-stream-time": number;
  "total-stream-bytes": number;
  "total-stream-frames": number;
  "recording": boolean;
  "total-record-time": number;
  "total-record-bytes": number;
  "total-record-frames": number;
  "stats": InstanceStats;
}

export interface InstanceInfo {
  status: string;
  heartbeat: InstanceHeartbeat;
  rtmp_muted: boolean;
}

export interface InitResponse {
    config: StreamConfig;
    instance_info: InstanceInfo;
}

export const streamControlReducers = (
  prevState: StreamControlState = { config: null, instanceInfo: null },
  action: any,
): StreamControlState => {
  const state: StreamControlState = Object.assign({}, prevState);

  if (!StreamControlActions) {
    return state;
  }

  switch (action.type) {
    case StreamControlActions.FetchStreamConfig:
      fetchStreamConfig();
      break;

    case StreamControlActions.SetCurrentScene:
      setScene(action.data);
      break;

    case StreamControlActions.SetLiveness:
      setLiveness(action.data);
      break;

    case StreamControlActions.SetStreamConfig:
      state.config = action.data;
      state.instanceInfo = action.data.instanceInfo;
      break;

    case StreamControlActions.SetInstanceInfo:
      state.instanceInfo = action.data;
      break;
  }

  return state;
};
