import * as React from 'react';
import { FormGroup, Input, InputType } from 'twitch-core-ui';

interface Props {
  setValue: (text: string | undefined) => string | undefined;
  defaultValue?: string | undefined;
  label: string;
  helperText?: HTMLElement;
}

interface State {
  validationError?: string;
}

export class TextInput extends React.Component<Props, State> {
  public state: State = {

  };

  constructor(props: Props, state: State) {
    super(props, state);
  }

  public render() {
    return (
      <FormGroup error={this.state.validationError !== undefined} errorMessage={this.state.validationError} label={this.props.label}>
        <Input type={InputType.Text} placeholder={this.props.label} onChange={this.onChange} value={this.props.defaultValue} />
      </FormGroup>
    );
  }

  private onChange = (event: React.FormEvent<HTMLInputElement>) => {
    let value: string | undefined = event.currentTarget.value;
    if (value === '') {
      value = undefined;
    }

    this.setState({
      validationError: this.props.setValue(value),
    });
  }
}
