import * as React from 'react';
import { Display, FormGroup, Layout, Radio } from 'twitch-core-ui';

interface ThemeItem {
  label: string;
  className: string;
  default?: boolean;
}

interface Props {
  availableThemes: ThemeItem[];
}

interface State {
  currentValue: string;
}

export class ThemeSwitcher extends React.Component<Props, State> {
  public state = {
    currentValue: '',
  };

  public render() {
    return (
      <FormGroup
        label="Theme"
      >
        <Layout display={Display.Flex}>
          {this.props.availableThemes.map((item) => (
            <Layout margin={{ right: 2 }} key={item.className}>
              <Radio
                name="settings-theme"
                label={item.label}
                value={item.className}
                checked={this.state.currentValue === item.className}
                onChange={this.onThemeSelected}
              />
            </Layout>
          ))}
        </Layout>
      </FormGroup>
    );
  }

  public componentDidMount() {
    const previousTheme = localStorage.getItem('currentThemeValue');

    if (previousTheme) {
      this.setCurrentTheme(previousTheme);
      return;
    }

    const defaultThemeObject = this.props.availableThemes.find((elem) => (elem.default === true));

    if (defaultThemeObject) {
      this.setCurrentTheme(defaultThemeObject.className);
    }
  }

  private onThemeSelected = (e: React.FormEvent<HTMLInputElement>) => {
    this.setCurrentTheme(e.currentTarget.value);
    localStorage.setItem('currentThemeValue', e.currentTarget.value);
  }

  private setCurrentTheme = (name: string) => {
    const wrapper = document.querySelector('html');

    if (wrapper) {
      this.props.availableThemes.filter((item) => (item.className !== name)).forEach((item) => {
        wrapper.classList.remove(item.className);
      });
      wrapper.classList.add(name);
    }

    this.setState({
      currentValue: name,
    });
  }
}
