import { userManager } from 'moonlight/components/oidc/userManager';
import { User } from 'oidc-client';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { OidcProvider } from 'redux-oidc';
import { App } from './App';
import './index.css';
import { unregister } from './registerServiceWorker';
import { store } from './utils/reduxStore';

// @ts-ignore
import * as analytics from 'universal-analytics';

export interface OidcState {
  isLoadingUser: boolean;
  user: User;
}

ReactDOM.render(
  (
    <Provider store={store}>
      <OidcProvider store={store} userManager={userManager}>
        <App />
      </OidcProvider>
    </Provider>
  ),
  document.getElementById('root') as HTMLElement,
);

// Remove any legacy service workers from before we disabled service workers;
// For our use case, we don't want anything cached EVER so we don't use the service worker.
unregister();
