import { push } from "connected-react-router";
import { OidcState } from 'moonlight';
import { SettingsContainer } from 'moonlight/components/settings';
import { User } from 'oidc-client';
import * as React from 'react';
import { Dispatch } from 'redux';
import { CoreText } from 'twitch-core-ui';

export interface PublicProps { }

export interface ReduxStateProps {
  oidc: OidcState;
}

export interface ReduxDispatchProps {
  dispatch: Dispatch;
}

export type Props = PublicProps & ReduxStateProps & ReduxDispatchProps;

interface State { }

export class SettingsContainerComponent extends React.Component<Props, State> {
  public render() {
    if (!this.props.oidc || this.props.oidc.isLoadingUser) {
      return '';
    }

    // Load channel controls
    if (!this.props.oidc.user || this.props.oidc.user.expired) {
      this.props.dispatch(push("/login"));
      return (
        <CoreText>Redirecting to login</CoreText>
      );
    }
    // If that fails show a message saying you don't have access
    return <SettingsContainer />;
  }
}
