import { GlobalState, store } from "moonlight/utils/reduxStore";
import { connect } from "react-redux";
import { bindActionCreators, Dispatch } from "redux";
import { logout } from "redux-implicit-oauth2";
import { ReduxDispatchProps, ReduxStateProps, SettingsContainerComponent } from "./component";

function mapDispatchToProps(dispatch: Dispatch): ReduxDispatchProps {
  return {
    dispatch,
  };
}

function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    oidc: state.oidc,
  };
}

export const SettingsContainer = connect(
  mapStateToProps,
  mapDispatchToProps
)(SettingsContainerComponent);
