import { connectRouter, routerMiddleware, RouterState } from "connected-react-router";
import { createBrowserHistory } from 'history';
import { OidcState } from 'moonlight';
import { userManager } from 'moonlight/components/oidc/userManager';
import { settingsReducers as settings, SettingsState } from "moonlight/components/settings/reducers";
import { streamControlReducers as streamControl, StreamControlState } from "moonlight/components/stream-control/reducers";
import { applyMiddleware, combineReducers, compose, createStore } from "redux";
import { loadUser } from "redux-oidc";
import { reducer as oidcReducer } from 'redux-oidc';
import thunk from "redux-thunk";

export const history = createBrowserHistory();

export interface GlobalState {
  router: RouterState;
  oidc: OidcState;
  streamControl: StreamControlState;
  settings: SettingsState;
}

const reducers = combineReducers({
  router: connectRouter(history),
  oidc: oidcReducer,
  streamControl,
  settings,
});

const composeEnhancers = (window as any).__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;

function configureStore(initialState = {}) {
  return createStore(
    reducers,
    initialState,
    composeEnhancers(applyMiddleware(routerMiddleware(history), thunk))
  );
}

export const store = configureStore();
loadUser(store, userManager);
