#!/bin/bash

chown -R obs:obs /var/log/moonlight
chown -R obs:obs /home/obs/.config

startx -- vt2 > /var/log/moonlight/Xorg.log 2>&1 &

sleep 1

# Allow related / established connections
iptables -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT

# Allow access from the gateway so that controlling stuff from the host still works
iptables -A INPUT -s 172.18.1.1/32 -j ACCEPT

# block connections from the moonlight bridge network
iptables -A INPUT -s 172.18.1.0/24 -j DROP

# Allow localhost DNS resolver
iptables -A OUTPUT -o lo -d 127.0.0.11/32 -p udp -j ACCEPT

# block access to localhost from OBS
iptables -A OUTPUT -o lo -m owner --uid-owner obs -j LOG --log-prefix 'LOCALHOST DROPPED: '
iptables -A OUTPUT -o lo -m owner --uid-owner obs -j DROP

# websockify -> VNC
/opt/websockify/run 5901 --cert=/self.pem --ssl-only --web=/opt/noVNC --wrap-mode=ignore -- vncserver -geometry 1600x900 -securitytypes otp -otp -noxstartup > /var/log/moonlight/vnc.log 2>&1 &

sleep 1

pulseaudio --start --log-target=file:/var/log/moonlight/pulseaudio.log

sleep 1

pacmd load-module module-null-sink sink_name=MySink > /var/log/moonlight/pacmd.log 2>&1

sleep 2

xhost +SI:localuser:obs
cp ~/.Xauthority /home/obs/.Xauthority
chown obs:obs /home/obs/.Xauthority

su - obs -c "vglrun obs" > /var/log/moonlight/obs.log 2>&1 &

tail -f /var/log/moonlight/obs.log
