package aws

import (
	logging "code.justin.tv/event-engineering/golibs/pkg/logging"
	"code.justin.tv/event-engineering/moonlight-daemon/pkg/aws/backend"
	"github.com/aws/aws-sdk-go/aws/ec2metadata"
	"github.com/aws/aws-sdk-go/service/cloudwatch"
	"github.com/aws/aws-sdk-go/service/ec2"
	"github.com/aws/aws-sdk-go/service/ecr"
	"github.com/aws/aws-sdk-go/service/lambda/lambdaiface"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/aws/aws-sdk-go/service/ssm"
	"time"
)

var presignedURLExpiry = 7 * 24 * time.Hour

// New generates a new AWS Client with the supplied backend client
func New(awsClient backend.Client, logger logging.Logger) *Client {
	return &Client{
		aws:    awsClient,
		logger: logger,
	}
}

// Client is an AWS client containing methods for use in the goldengate system
type Client struct {
	aws    backend.Client
	logger logging.Logger
}

// GetLambdaClient returns the lambda client for use in twirp lambda transport
func (c *Client) GetLambdaClient() lambdaiface.LambdaAPI {
	return c.aws.GetLambdaClient()
}

// SQSCreateQueue calls the underlying SQSCreateQueue from the aws backend
func (c *Client) SQSCreateQueue(input *sqs.CreateQueueInput) (*sqs.CreateQueueOutput, error) {
	return c.aws.SQSCreateQueue(input)
}

// SQSGetQueueUrl calls the underlying SQSGetQueueUrl from the aws backend
func (c *Client) SQSGetQueueUrl(input *sqs.GetQueueUrlInput) (*sqs.GetQueueUrlOutput, error) {
	return c.aws.SQSGetQueueUrl(input)
}

// SQSDeleteQueue calls the underlying SQSDeleteQueue from the aws backend
func (c *Client) SQSDeleteQueue(input *sqs.DeleteQueueInput) (*sqs.DeleteQueueOutput, error) {
	return c.aws.SQSDeleteQueue(input)
}

// SQSReceiveMessage calls the underlying SQSReceiveMessage from the aws backend
func (c *Client) SQSReceiveMessage(input *sqs.ReceiveMessageInput) (*sqs.ReceiveMessageOutput, error) {
	return c.aws.SQSReceiveMessage(input)
}

// SSMGetParameters calls the underlying SSMGetParameters from the aws backend
func (c *Client) SSMGetParameters(input *ssm.GetParametersInput) (*ssm.GetParametersOutput, error) {
	return c.aws.SSMGetParameters(input)
}

// EC2MGetInstanceIdentityDocument calls the underlying EC2MGetInstanceIdentityDocument from the aws backend
func (c *Client) EC2MGetInstanceIdentityDocument() (ec2metadata.EC2InstanceIdentityDocument, error) {
	return c.aws.EC2MGetInstanceIdentityDocument()
}

// EC2DescribeInstances calls the underlying EC2DescribeInstances from the aws backend
func (c *Client) EC2DescribeInstances(input *ec2.DescribeInstancesInput) (*ec2.DescribeInstancesOutput, error) {
	return c.aws.EC2DescribeInstances(input)
}

// ECRGetAuthorizationToken calls the underlying ECRGetAuthorizationToken from the aws backend
func (c *Client) ECRGetAuthorizationToken(input *ecr.GetAuthorizationTokenInput) (*ecr.GetAuthorizationTokenOutput, error) {
	return c.aws.ECRGetAuthorizationToken(input)
}

// CWPutMetricData calls the underlying CWPutMetricData from the aws backend
func (c *Client) CWPutMetricData(input *cloudwatch.PutMetricDataInput) (*cloudwatch.PutMetricDataOutput, error) {
	return c.aws.CWPutMetricData(input)
}
